<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CGalleryWidgetImagesWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Images w/ Carousel",
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {

		switch ($widget["settings"]["set_order"]) {
			case "1":
				$order = " rand() ";
			break;

			default:
			case "2":
				$order = " r.item_id DESC ";
			break;
			
			case "3":
				$order = " r.item_id ASC ";
			break;
		}

		if ($widget["settings"]["set_album"]) {
			$cond = " AND c.cat_id=" . $widget["settings"]["set_album"] . " " ; 
		}
		
		$photos = $this->plugins["media"]->Gallery(
			$widget["settings"]["set_album"] , 
			$widget["mod_id"] , 
			"",
			"",
			"array",
			array(
				"path"	=> "upload/gallery",
				"tn"	=> $widget["settings"]["set_height"] ? "tn" : "tn2",
				"order"	=> $order,
				"max"	=> max(1, $widget["settings"]["set_items"]),
			)
		);


		if (is_Array($photos)) {

			global $base;

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"images"	=> $base->html->Table(
						$this->tpl , 
						"",
						$photos
					),

					"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),


					"thumbs"	=> $widget["settings"]["set_carousel_thumbs"] ? $base->html->table(
						$this->tpl,
						"Thumbs",
						$photos
					) : ""

				),
				$widget["settings"],
				$widget
			);

			
		}
		
	}
	
	

}


?>